from lchttp.json import json_loads
from channels.consumer import AsyncConsumer

import logging

logger = logging.getLogger(__name__)


class ClarionConsumer(AsyncConsumer):
    """
    ClarionConsumer to be subclassed by other consumers.
    """

    async def connect(self):
        """
        Connect method to be subclassed by consumers.
        """
        pass

    async def disconnect(self, event):
        """
        Disconnect method to be subclassed by consumers.
        """
        pass

    async def receive(self, clarion_message):
        """
        Receive method to be subclassed by consumers.
        """
        pass

    async def clarion_connect(self, event):
        """
        Initialize connection.
        """
        await self.connect()

    async def clarion_disconnect(self, event):
        """
        Initialize disconnection.
        """
        await self.disconnect(0)

    async def clarion_receive(self, event):
        """
        Handle an incoming message from Clarion and
        forward it to Channels.
        """
        try:
            event["body"] = json_loads(event["body"])
        except (KeyError, ValueError):
            pass

        await self.receive(event)

    async def clarion_send(self, room, body):
        """
        Handle an incoming message from Channels: forward it to Clarion.
        """
        await self.send({"type": "clarion.send", "room": room, "body": body})
