from console_base.choices import LCTextChoicesMixin
from django.db.models import TextChoices
from django.utils.translation import gettext_lazy as _


# ---------------------------------------------------------------------------
class CONTEXT(LCTextChoicesMixin, TextChoices):
    Event = 'pgh_context', 'Context from local Concord Event'
    Origin = 'origin_context', "Subscriber's original Concord Event Context"
    Keys = 'keys', "Context Keys from Subscriber's Event Context"


# ---------------------------------------------------------------------------
class SYNCMODES(LCTextChoicesMixin, TextChoices):
    """
    Should records be deleted on the local console only,
    or synchronized among all the consoles?
    """
    Sync = 'sync', _('Sync Everywhere')
    Local = 'local', _('Local System Only')


# ---------------------------------------------------------------------------
class CRUD(LCTextChoicesMixin, TextChoices):
    Create = 'create', 'Create'
    Update = 'update', 'Update'
    Delete = 'delete', 'Delete'
    Toggle = 'toggle', 'Toggle'


# ---------------------------------------------------------------------------
class ORIGIN_SERVER(LCTextChoicesMixin, TextChoices):
    CID = 'origin_server_cid', _('Origin Appliance / Server CID')
    Name = 'origin_server_name', _('Origin Appliance / Server Name')
