from typing import NamedTuple, Optional, TYPE_CHECKING
if TYPE_CHECKING:
    from .models import ConcordEvents, SyncableModel
    from concordia_tests.latchstring.models import User


class Record(NamedTuple):
    """
    When a Subscriber posts a message to the Publisher,
    the Subscriber user should have access to the record,
    using the Model.objects.tenant(user) queryset.
    """
    editor: 'User'
    obj: Optional['SyncableModel']
    permitted: bool


class Status(NamedTuple):
    success: bool
    message: dict


class EventData(NamedTuple):
    data: dict
    events: 'ConcordEvents'
