from django.contrib.contenttypes.models import ContentType
from ..querysets import ConcordiaContentTypeManager


# ---------------------------------------------------------------------------
class ConcordiaContentType(ContentType):  # type: ignore
    """
    Proxy model to make it easier to add contacts via API
    RPC Methods such as changing filter password should be
    attached viewsets of this model.
    """
    IS_SYNCABLE = False

    objects = ConcordiaContentTypeManager()

    class Meta:
        proxy = True
        app_label = 'concordia'

    def __str__(self) -> str:
        return self.name.title()

    @property
    def ctmodel(self) -> str:
        """For API consistency with SyncTable"""
        return str(self.model)
