from concordia.models import (
    CanonicalIdDeleteLog,
    CanonicalIdMap,
    CanonicalIdSwap,
)
from .filters import (
    CanonicalIdDeleteLogFilter,
    CanonicalIdMapFilter,
    CanonicalIdSwapFilter,
)
from console_base.api.viewsets import LCModelViewSet
from .serializers import (
    CanonicalIdDeleteLogSerializer,
    CanonicalIdMapSerializer,
    CanonicalIdSwapSerializer,
)


# ---------------------------------------------------------------------------
class CanonicalIdDeleteLogViewSet(LCModelViewSet):
    queryset = CanonicalIdDeleteLog.objects.select_related('table')
    serializer_class = CanonicalIdDeleteLogSerializer
    filterset_class = CanonicalIdDeleteLogFilter


# ---------------------------------------------------------------------------
class CanonicalIdMapViewSet(LCModelViewSet):
    queryset = CanonicalIdMap.objects.select_related('table')
    serializer_class = CanonicalIdMapSerializer
    filterset_class = CanonicalIdMapFilter


# ---------------------------------------------------------------------------
class CanonicalIdSwapViewSet(LCModelViewSet):
    queryset = CanonicalIdSwap.objects.select_related('table')
    serializer_class = CanonicalIdSwapSerializer
    filterset_class = CanonicalIdSwapFilter
