from console_base.api.serializers import (
    LCHyperlinkedIdentityField,
    LCModelSerializer,
)
from concordia.models import CanonicalIdDeleteLog, CanonicalIdMap, CanonicalIdSwap


# ---------------------------------------------------------------------------
class CanonicalIdDeleteLogSerializer(LCModelSerializer):

    url = LCHyperlinkedIdentityField(view_name='api-canonicaliddeletelog-detail')

    class Meta(LCModelSerializer.Meta):
        model = CanonicalIdDeleteLog
        fields = (
            'url',
            'cid',
            'name',
            'table',
            'object_id',
            'app_label',
            'table_name',
        )


# ---------------------------------------------------------------------------
class CanonicalIdMapSerializer(LCModelSerializer):

    url = LCHyperlinkedIdentityField(view_name='api-canonicalidmap-detail')

    class Meta(LCModelSerializer.Meta):
        model = CanonicalIdMap
        fields = (
            'url',
            'cid',
            'local',
            'name',
            'table',
            'object_id',
            'app_label',
            'table_name',
        )


# ---------------------------------------------------------------------------
class CanonicalIdSwapSerializer(LCModelSerializer):

    url = LCHyperlinkedIdentityField(view_name='api-canonicalidswap-detail')

    class Meta(LCModelSerializer.Meta):
        model = CanonicalIdSwap
        fields = (
            'url',
            'cid',
            'old',
            'name',
            'table',
            'object_id',
            'app_label',
            'table_name',
        )
