from django_filters import rest_framework as filters

from console_base.filters import NameFilter

from concordia.models import CanonicalIdDeleteLog, CanonicalIdMap, CanonicalIdSwap


# ---------------------------------------------------------------------------
class CanonicalIdDeleteLogFilter(NameFilter):

    table = filters.CharFilter(field_name='table', lookup_expr='exact')
    app_label = filters.CharFilter(
        field_name='table__app_label',
        lookup_expr='exact',
        label='App Name',
    )
    table_name = filters.CharFilter(
        field_name='table__model',
        lookup_expr='exact',
        label='Table Name',
    )

    class Meta(NameFilter.Meta):
        model = CanonicalIdDeleteLog
        fields = NameFilter.Meta.fields + (
            'table',
            'app_label',
            'table_name',
        )


# ---------------------------------------------------------------------------
class CanonicalIdMapFilter(CanonicalIdDeleteLogFilter):

    class Meta(CanonicalIdDeleteLogFilter.Meta):
        model = CanonicalIdMap


# ---------------------------------------------------------------------------
class CanonicalIdSwapFilter(CanonicalIdDeleteLogFilter):

    class Meta(CanonicalIdDeleteLogFilter.Meta):
        model = CanonicalIdSwap
