from typing import NamedTuple


class DerivedField(NamedTuple):
    """
    Configuration value is automatically derived from other configuration values.
    IE, the server_name='thinkwell' should be part of the public_baseurl value.
    """
    name: str
    value: str
    overwrite: bool


class DirectoryKeyMap(NamedTuple):
    """
    Directory config values should be loaded from homeserver values when possible.
    """
    homeserver: str
    directory: str
