from subprocess import run
from claradm import cli


@cli.root.group(chain=True)
def service():
    """ Restart Clarion Server and Workers.
    """

@service.command()
def restart():
    """ Restart Clarion Server and Workers.
    """
    run(['systemctl', 'restart', 'clarion-server.service'])
    run(['systemctl', 'restart', 'clarion-worker@client.service'])
    run(['systemctl', 'restart', 'clarion-worker@federation.service'])
    run(['systemctl', 'restart', 'clarion-directory.service'])


@service.command()
def stop():
    """ Stop Clarion Server and Workers.
    """
    run(['systemctl', 'restart', 'clarion-server.service'])
    run(['systemctl', 'restart', 'clarion-worker@client.service'])
    run(['systemctl', 'restart', 'clarion-worker@federation.service'])
    run(['systemctl', 'restart', 'clarion-directory.service'])
