

def get_nested_key(data, key, default=None):
    """
    Get value for specified key. If the key is colon-delimited,
    the dictionary is nested.

    data = {
        'email': {
            'smtp_host': 'mail.host.com',
            'smtp_port': 587,
        }
    }

    Key of "email:smtp_port" return 587, just as data['email']['smtp_port']
    """
    parent_dict = data
    for key in key.split(':'):
        try:
            parent_dict = parent_dict[key]
        except KeyError:
            return default

    return parent_dict or default


def set_nested_key(data, key, value):
    """
    Set key in config to the specified value. If key is colon-delimited,
    then dict is nested.

    Set key in config to the specified value. If key is colon-delimited,
    then dict is nested.

    data = {
        'email': {
            'smtp_host': 'mail.host.com',
            'smtp_port': 587,
        }
    }
    Key of "email:smtp_host" should set `value` as data['email']['smtp_port'] = 'mail.host.net'
    """
    keys = key.split(':')
    key_count = len(keys)

    if key_count == 1:
        data[key] = value
        return data

    parent_dict = data
    for i, sub_key in enumerate(keys):
        try:
            leaf_dict = parent_dict[sub_key]
            if isinstance(leaf_dict, dict):
                parent_dict = leaf_dict
            else:
                parent_dict[sub_key] = value
        except KeyError:
            # If a key is missing, add iterate over all remaining keys
            # adding them to the dictionary and then return
            missing_keys = keys[i:key_count]
            missing_count = len(missing_keys)
            for m_i, missing_sub_key in enumerate(missing_keys):
                if m_i + 1 < missing_count:
                    parent_dict[missing_sub_key] = {}
                    parent_dict = parent_dict[missing_sub_key]
                else:
                    parent_dict[missing_sub_key] = value
            return data

    return data
