from subprocess import run
from claradm import cli


@cli.root.group(chain=True)
def service():
    """ Restart Clarion Server and Workers.
    """

@service.command()
def status():
    """ Show status of Clarion Server and Workers.
    """
    run(['systemctl', 'status', 'clarion-server.service'])
    run(['systemctl', 'status', 'clarion-worker@client.service'])
    run(['systemctl', 'status', 'clarion-worker@federation.service'])
    run(['systemctl', 'status', 'clarion-directory.service'])

@service.command()
def restart():
    """ Restart Clarion Server and Workers.
    """
    run(['systemctl', 'restart', 'clarion-server.service'])
    print("Restarted Clarion Server")
    run(['systemctl', 'restart', 'clarion-worker@client.service'])
    print("Restarted Clarion Client Worker")
    run(['systemctl', 'restart', 'clarion-worker@federation.service'])
    print("Restarted Clarion Federation Worker")
    run(['systemctl', 'restart', 'clarion-directory.service'])
    print("Restarted Clarion Directory")


@service.command()
def stop():
    """ Stop Clarion Server and Workers.
    """
    run(['systemctl', 'stop', 'clarion-server.service'])
    run(['systemctl', 'stop', 'clarion-worker@client.service'])
    run(['systemctl', 'stop', 'clarion-worker@federation.service'])
    run(['systemctl', 'stop', 'clarion-directory.service'])

@service.command()
def enable():
    """ Enable Clarion Server and Workers.
    """
    run(['systemctl', 'enable', 'clarion-timer.service'])
    run(['systemctl', 'enable', 'clarion-server.service'])
    run(['systemctl', 'enable', 'clarion-worker@client.service'])
    run(['systemctl', 'enable', 'clarion-worker@federation.service'])
    run(['systemctl', 'enable', 'clarion-directory.service'])
    run(['systemctl', 'enable', 'clarion-sygnal.service'])
