import click
from claradm import cli

from pydrawbridgeos.client import LocalDrawBridgeApi
from pydrawbridgeos.exceptions import ConsoleAPIClientError

api = LocalDrawBridgeApi()


@cli.root.group(chain=True)
def firewall():
    """ Configure Firewall rules on a Drawbridge running Clarion
    """


@firewall.command()
def clarion_servers():

    clarion_servers = [
        "status.clarion.im",
        "bigrock.clarion.im",
        "cfca.clarion.im",
        "clarus.clarion.im",
        "compass.clarion.im",
        "emeraldpower.clarion.im",
        "mm.clarion.im",
        "norcell.clarion.im",
        "plugger.clarion.im",
        "sonfollowers.clarion.im",
        "thinkwell.clarion.im",
        "wireman.clarion.im",
        "zeiset.clarion.im",
        "zimmermanchair.clarion.im",
    ]

    commands = []

    for server in clarion_servers:
        commands.append([
            "set", "firewall", "group", "domain-group", "clarion-servers", "address", server
        ])

    try:
        api.multi_configure(commands)
        print(clarion_servers)

    except ConsoleAPIClientError:
        print('Unable to define Zabbix configuration')


# yapf: disable
@firewall.command()
def port_80():

    commands = [
        ["set", "firewall", "ipv4", "name", "internet-local", "rule", "54", "action", "accept"],
        ["set", "firewall", "ipv4", "name", "internet-local", "rule", "54", "destination", "port", "80"],
        ["set", "firewall", "ipv4", "name", "internet-local", "rule", "54", "protocol", "tcp"],
        ["set", "firewall", "ipv4", "name", "internet-local", "rule", "54", "inbound-interface", "name", "eth0"],
    ]

    try:
        api.multi_configure(commands)
        print('Port 80 configured for internet-local')

    except ConsoleAPIClientError:
        print('Unable to define Zabbix configuration')


@firewall.command()
def port_443():

    commands = [
        ["set", "firewall", "ipv4", "name", "internet-local", "rule", "55", "action", "accept"],
        ["set", "firewall", "ipv4", "name", "internet-local", "rule", "55", "destination", "port", "443"],
        ["set", "firewall", "ipv4", "name", "internet-local", "rule", "55", "protocol", "tcp"],
        ["set", "firewall", "ipv4", "name", "internet-local", "rule", "55", "inbound-interface", "name", "eth0"],
        ["set", "firewall", "ipv4", "name", "internet-local", "rule", "55", "source", "geoip", "country-code", "us"],
        ["set", "firewall", "ipv4", "name", "internet-local", "rule", "55", "source", "geoip", "country-code", "ca"],
    ]

    try:
        api.multi_configure(commands)
        print('Port 443 configured for internet-local')
    except ConsoleAPIClientError:
        print('Unable to define Zabbix configuration')


@firewall.command()
def port_8448():

    commands = [
        ["set", "firewall", "ipv4", "name", "internet-local", "rule", "56", "action", "accept"],
        ["set", "firewall", "ipv4", "name", "internet-local", "rule", "56", "destination", "port", "8448"],
        ["set", "firewall", "ipv4", "name", "internet-local", "rule", "56", "inbound-interface", "name", "eth0"],
        ["set", "firewall", "ipv4", "name", "internet-local", "rule", "56", "protocol", "tcp"],
        ["set", "firewall", "ipv4", "name", "internet-local", "rule", "56", "source", "group", "domain-group", "clarion-servers"],
    ]

    try:
        api.multi_configure(commands)
        print('Port 8448 configured for internet-local')

    except ConsoleAPIClientError:
        print('Unable to define Zabbix configuration')


@firewall.command(name='all')
@click.pass_context
def set_all_firewalls(ctx):
    """ Set all firewall rules.
    """
    ctx.forward(port_80)
    ctx.forward(port_443)
    ctx.forward(port_8448)