import click
from subprocess import run
from claradm import cli


@cli.root.group(chain=True)
def restart():
    """ Restart Clarion Server and Workers.
    """

@restart.command()
@click.pass_context
def directory(ctx):
    """ Restart Clarion Directory.
    """
    run(['systemctl', 'restart', 'clarion-directory.service'])


@restart.command()
@click.pass_context
def server(ctx):
    """ Restart Clarion Homeserver.
    """
    run(['systemctl', 'restart', 'clarion-server.service'])


@restart.command()
@click.pass_context
def workers(ctx):
    """ Restart Clarion Workers.
    """
    run(['systemctl', 'restart', 'clarion-worker@client.service'])
    run(['systemctl', 'restart', 'clarion-worker@federation.service'])


@restart.command(name='all')
@click.pass_context
def restart_all(ctx):
    """ Restart Clarion Server and Workers.
    """
    ctx.forward(server)
    ctx.forward(workers)
    ctx.forward(directory)
