import os
import sys
from setuptools import setup


if sys.argv[-1] == 'test':
    status = os.system('python tests/tests.py')
    sys.exit(1 if status > 127 else status)


def long_description():
    return "Python library to communicate with Centrifugo API"


setup(
    name='cent',
    version='5.1.0',
    description="Python library to communicate with Centrifugo API",
    long_description=long_description(),
    url='https://github.com/centrifugal/cent',
    download_url='https://github.com/centrifugal/cent',
    author="Alexandr Emelin",
    author_email='frvzmb@gmail.com',
    license='MIT',
    packages=['cent', 'cent/client', 'cent/client/session'],
    install_requires=[
        'curl-cffi',
        'msgspec',
    ],
    classifiers=[
        'Development Status :: 5 - Production/Stable',
        'Programming Language :: Python',
        'Programming Language :: Python :: 3.11',
        'Environment :: Console',
        'Intended Audience :: Developers',
        'Intended Audience :: System Administrators',
        'License :: OSI Approved :: Apache Software License',
        'Topic :: Internet :: WWW/HTTP',
        'Topic :: Software Development',
        'Topic :: System :: Networking',
        'Topic :: Terminals',
        'Topic :: Text Processing',
        'Topic :: Utilities'
    ]
)
