from invoke import Context, task


@task
def stop(ctx: Context) -> None:
    """
    Stop all console services.
    """
    ctx.run('systemctl stop portal-server portal-cluster portal-beat passageway hedge')


@task
def start(ctx: Context) -> None:
    """
    Start all console services.
    """
    ctx.run('systemctl start portal-server portal-cluster portal-beat passageway hedge')


__all__ = (
    'stop',
    'start',
)
