from invoke import Context, task
from capsule import settings
from capsule.utils.zabbix import record_successful_backup_time

from .etc import backup as etc_backup

backup_tasks = [etc_backup]

if settings.IS_ASPEN:
    from .certs import backup as cert_backup

    backup_tasks.append(cert_backup)


if settings.BACKUP_POSTGRES_DATABASES:
    from .db import backup as db_backup

    backup_tasks.append(db_backup)

if settings.IS_DRAWBRIDGE_OS:
    from .dbos import backup as dbos_backup

    backup_tasks.append(dbos_backup)


@task
def backup(ctx: Context) -> None:  # noqa
    """
    Run all backup tasks on this system.
    """
    failed = False
    for backup_task in backup_tasks:
        try:
            backup_task(ctx)
        except Exception as e:
            print(e)
            failed = True

    if not failed:
        record_successful_backup_time(settings.LAST_SUCCESSFUL_BACKUP)


__all__ = [
    'backup',
]
