from invoke import task


from ..backups import BackupCerts, object_server_client
from ..downloader import downloader
from ..settings import S3_REGION
from ..typehints import INTERVALS, S3_REGIONS


@task(
    help={
        'region': f'Region for saving the archive file. Default: {S3_REGION!r}',
    },
)
def backup(ctx, region: S3_REGIONS = S3_REGION) -> bool:
    """
    Backup all contents of the Aspen certs directory.
    """
    print('Backup contents of the Aspen certs directory.... ', end='', flush=True)
    client = object_server_client(region)
    BackupCerts(ctx, filename='certs.tbz2', client=client).process()
    print('Done')
    return True


@task(
    help={
        'interval': 'File archive interval - (daily, weekly, monthly)',
        'region': f'Region for saving the archive file. Default: {S3_REGION!r}',
    },
)
def backup_files(ctx, interval: INTERVALS = '', region: S3_REGIONS = S3_REGION):
    """
    Show all Aspen cert files for specified interval.
    """
    client = object_server_client(region)
    backups = BackupCerts(ctx, filename='', interval='', client=client).backups(interval=interval)

    for interval, db_backups in backups.items():  # type: ignore[assignment]
        print(f'\n{interval.title()} backup files')
        for bf in db_backups:
            print(bf)
        print()


@task(
    help={
        'interval': 'File archive interval - (daily, weekly, monthly)',
        'filename': 'Remote backup filename to download',
        'region': f'Region for saving the archive file. Default: {S3_REGION!r}',
    },
)
def download(ctx, interval: INTERVALS, filename: str, region: S3_REGIONS = S3_REGION):
    """
    Download specified Etc backup tarball from the backup server.
    """
    downloader(
        interval,
        filename,
        base_prefix=BackupCerts.base_prefix,
        region=region,
    )


__all__ = (
    'backup',
    'backup_files',
    'download',
)
