import os
import re
import sys

if sys.version_info < (3, 14):
    import tarfile
else:
    from capsule.utils import optimized_tarfile as tarfile


def create_tarball(
    source_dirs: tuple[str, ...],
    destination: str,
    exclude_patterns: tuple[str, ...],
):
    """
    Creates a compressed archive of a directory, excluding files matching specified patterns.

    :param source_dirs: A tuple of directories to compress and archive.
    :param destination: The name of the compressed output file.
    :param exclude_patterns: A tuple of regex patterns to exclude from the tarball.
    """
    with tarfile.open(destination, "w:bz2") as tb:
        for source_dir in source_dirs:
            for root, _, files in os.walk(source_dir):
                for file in files:
                    file_path = os.path.join(root, file)

                    excluded = False
                    for pattern in exclude_patterns:
                        if re.search(pattern, file_path):
                            excluded = True
                            break

                    if not excluded:
                        tb.add(file_path)
