from lcconfig import ConsoleSettingsConfig


def get_bucket_name() -> str:
    return _get_config_param('name').replace(' ', '').lower()


def get_system_name() -> str:
    return _get_config_param('name')


def _get_config_param(param: str):
    """
    Lookup prams from config file, via function
    call, so we re-check the config file every time the
    function is invoked

    This is needed since during setup of new systems,
    the value will not be set, so we can't just load
    the value once at program launch.
    """
    cfg = ConsoleSettingsConfig().load()
    data = cfg.as_typed_dict('BoxData')
    return data.get(param) or ''
