# mypy: disable-error-code="arg-type"
from invoke import Collection
from capsule import settings
from . import config
from . import services

ns = Collection()
ns.add_collection(config)  # noqa
ns.add_collection(services)  # noqa

if settings.object_storage_cfg:
    from . import console
    from . import etc
    from . import dbos

    if settings.BACKUP_POSTGRES_DATABASES:
        from . import db

        ns.add_collection(db)  # noqa

    ns.add_collection(console)  # noqa
    ns.add_collection(etc)  # noqa

    if settings.IS_DRAWBRIDGE_OS:
        ns.add_collection(dbos)  # noqa

    if settings.IS_ASPEN:
        from . import certs

        ns.add_collection(certs)  # noqa
