# Capsule Backup Center

Manage database and config file backups for Log Cabin consoles and Compass servers.


#### Usage

### 1. See all available commands and docstrings by running:

`capsule --list`

### 2. Get complete help text for a command

`capsule <command.name> --help`

```bash
$ capsule -h db.restore
Usage: capsule [--core-opts] config.restores [--options] [other tasks here ...]

Docstring:
  Dump database (if existing) and create from backup file downloaded from the backup server.

Options:
  -f STRING, --filename=STRING   Backup filename to download
  -i STRING, --interval=STRING   File archive interval - (daily, weekly, monthly)
  -n STRING, --name=STRING       Database name to restore
```


## Debug

To print full debug output pass the `-d` param before the command name:

`capsule -d <command.name>`

To echo `run` commands, set the `INVOKE_RUN_ECHO` environment variable.

`export INVOKE_RUN_ECHO=1`


## Configuration
On servers other than DrawBridge appliances, `capsule` requires configuration files at 

```editorconfig
/etc/compass/settings.conf
[default_email]
host = smtp2.thesecurityappliance.com
port = 587
use_tls = True
username = reports@thesecurityappliance.com
password = <pwd_hash>
from_address = reports@thesecurityappliance.com

[BoxData]
name = <server_name>
adminurl = <server_dns_name>
cid = <aspen_cid>
```

```editorconfig
/etc/compass/minio.conf
[Compass]
endpoint = <endpoint_hash>
access_key = <access_key_hash>
secret_key = <secret_key_hash>
```

Add a `cron` job to call the capsule backup tasks.

12 01 * * * /usr/bin/capsule console.backup
