from console_keyring.console_keyring import ConsoleKeyring
import logging
from lcconfig import ObjectStorageConfig

logger = logging.getLogger(__name__)


def persist_object_storage_config(endpoint: str, region: str, creds: dict, service: str) -> None:
    """
    Save the S3 Object Storage config file.
    """
    cfg = ObjectStorageConfig()
    cfg_data = cfg.as_typed_dict('Compass')
    new_data = {
        'endpoint': endpoint,
        'region': region,
    }

    cfg_updated = False
    for key in ('endpoint', 'region'):
        if not cfg_updated and cfg_data.get(key) != new_data[key]:
            cfg_updated = True

    if cfg_updated:
        cfg_data |= new_data
        cfg.save_section(section='Compass', data=cfg_data)

    kr = ConsoleKeyring()
    secrets_updated = False

    for key in ('access_key', 'secret_key'):
        if new_secret := creds.get(key):
            if new_secret != kr.get_password(service, key):
                kr.set_password(service, key, new_secret)
                secrets_updated = True

    if cfg_updated or secrets_updated:
        logger.info('Updated S3 Object Storage configuration file')
