from dataclasses import dataclass
from typing import Literal, NamedTuple


@dataclass(frozen=True)
class KeyringService:
    LocalConsole: str = 'console'
    ImpersonatingConsole: str = 'impersonating'


class DatabaseStatus(NamedTuple):
    exists: bool
    created: bool


INTERVALS = Literal['', 'daily', 'weekly', 'monthly']
S3_REGIONS = Literal['bigrock', 'greenbarn', 'ironwood']
