from invoke import Context, task

from ..backups import BackupEtc
from ..downloader import downloader
from ..typehints import INTERVALS


@task
def backup(ctx: Context) -> None:
    """
    Backup all contents of the /etc directory.
    """
    print(f'Backing up {BackupEtc.directory}... ', end='', flush=True)
    BackupEtc(ctx, filename='etc.tbz2').process()
    print('Done')


@task(
    help={
        'interval': 'File archive interval - (daily, weekly, monthly)',
    },
)
def backup_files(ctx: Context, interval: INTERVALS = '') -> None:
    """
    Show all Etc backup files for specified interval.
    """
    backups = BackupEtc(ctx, filename='', interval='').backups(interval=interval)

    for interval, db_backups in backups.items():  # type: ignore[assignment]
        print(f'\n{interval.title()} backup files')
        for bf in db_backups:
            print(bf)
        print()


@task(
    help={
        'interval': 'File archive interval - (daily, weekly, monthly)',
        'filename': 'Remote backup filename to download',
    },
)
def download(ctx: Context, interval: INTERVALS, filename: str) -> None:
    """
    Download specified Etc backup tarball from the backup server.
    """
    downloader(interval, filename, BackupEtc.base_prefix)


__all__ = (
    'backup',
    'backup_files',
    'download',
)
