from invoke import Context, task

from ..backups import BackupDBOSConfig
from ..downloader import downloader
from ..typehints import INTERVALS


@task
def backup(ctx: Context) -> None:
    """
    Backup all contents of the /config directory
    """
    print(f'Backing up {BackupDBOSConfig.directory}... ', end='', flush=True)
    BackupDBOSConfig(ctx, filename='dbos.tbz2').process()
    print('Done')


@task(help={'interval': 'File archive interval - (hourly, daily, weekly, monthly)'})
def backup_files(ctx: Context, interval: INTERVALS = '') -> None:
    """
    Show DrawBridgeOS config backup files for specified interval.
    """
    backups = BackupDBOSConfig(ctx, filename='', interval='').backups(interval=interval)

    for interval, db_backups in backups.items():  # type: ignore[assignment]
        print(f'\n{interval.title()} backup files')
        for bf in db_backups:
            print(bf)
        print()


@task(
    help={
        'interval': 'File archive interval - (daily, weekly, monthly)',
        'filename': 'Remote backup filename to download',
    },
)
def download(ctx: Context, interval: INTERVALS, filename: str) -> None:
    """
    Download specified DrawBridgeOS config backup tarball from the backup server.
    """
    downloader(interval, filename, BackupDBOSConfig.base_prefix)


__all__ = (
    'backup',
    'backup_files',
    'download',
)
