from invoke import Context, task
from capsule import settings

from .etc import backup as etc_backup

pre_tasks = [etc_backup]

if settings.IS_ASPEN:
    from .certs import backup as cert_backup

    pre_tasks.append(cert_backup)


if settings.BACKUP_POSTGRES_DATABASES:
    from .db import backup as db_backup

    pre_tasks.append(db_backup)

if settings.IS_DRAWBRIDGE_OS:
    from .dbos import backup as dbos_backup

    pre_tasks.append(dbos_backup)


@task(pre=pre_tasks)
def backup(ctx: Context) -> None:  # noqa
    """
    Run all backup tasks on this system.
    """
    pass


__all__ = [
    'backup',
]
