from lcconfig import ConsoleSettingsConfig, ObjectStorageConfig
import logging.config
from system_env.environment import setup_portal_environment

BACKUP_POSTGRES_DATABASES = False

try:
    import psycopg

    BACKUP_POSTGRES_DATABASES = True
except ModuleNotFoundError:
    try:
        import psycopg2

        BACKUP_POSTGRES_DATABASES = True
    except ModuleNotFoundError:
        pass

PORTAL_ENV = setup_portal_environment()
PROJECT_ROOT = PORTAL_ENV['PROJECT_ROOT']
APPS_ROOT = f'{PROJECT_ROOT}/apps'
IS_DRAWBRIDGE_OS = PORTAL_ENV['IS_DRAWBRIDGE_OS']
DB_HOST = '/var/run/postgresql' if IS_DRAWBRIDGE_OS else '/tmp'
DATABASE_NAME = PORTAL_ENV['PORTAL_CODE_NAME']
TMP_DIR = f'/var/tmp/{PORTAL_ENV["PORTAL_CODE_NAME"]}'

OPT_DIR = '/opt'
ETC_DIR = '/etc'
if IS_DRAWBRIDGE_OS:
    ETC_DIR = '/etc/drawbridge_portal'

cfg = ConsoleSettingsConfig().load()
ASPEN_CFG = cfg.as_typed_dict('AspenCtl')
IS_ASPEN = bool(ASPEN_CFG)

object_storage_cfg = ObjectStorageConfig().as_typed_dict('Compass')
S3_ENDPOINT = object_storage_cfg.get('endpoint', 'garage01.compassfoundation.net')
S3_REGION = object_storage_cfg.get('region', 'ironwood')

REGION_ENDPOINT_MAP = {
    'greenbarn': 'garage01.compassfoundation.net',
    'bigrock': 'garage02.compassfoundation.net',
    'ironwood': 'garage03.compassfoundation.net',
}

HOURLY_MAX_FILE_COUNT = 24
DAILY_MAX_FILE_COUNT = 7
MONTHLY_MAX_FILE_COUNT = 6
WEEKLY_MAX_FILE_COUNT = 4

LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'default_formatter': {
            'format': "[%(asctime)s] %(levelname)s [%(name)s:%(lineno)s] %(message)s",
            'datefmt': "%Y-%m-%d %H:%M:%S",
        },
    },
    'handlers': {
        'console': {
            'class': 'logging.StreamHandler',
            'formatter': 'default_formatter',
        },
    },
    'loggers': {
        'capsule': {
            'handlers': ['console'],
            'propagate': True,
            'level': 'INFO',
        },
    },
}

logging.config.dictConfig(LOGGING)
