import time
from unittest import TestCase

from aspen_crypto.encryption import encrypt, decrypt, mask, unmask
from aspen_crypto.otp import generate_totp, verify_totp


# -------------------------------------------------------------------------
class TestValidateEncryption(TestCase):
    def test_encrypt_to_decrypt(self):
        string = 'the super secret message'

        self.assertEqual(decrypt(encrypt(string)), string)

    def test_mask_unmask(self):
        string = 'the masked message'

        self.assertEqual(unmask(mask(string)), string)


# -------------------------------------------------------------------------
class TestTotp(TestCase):
    def test_onetime_password(self):
        secret = 'the big secret'
        interval = 30
        otp = generate_totp(secret, interval).now()
        self.assertTrue(verify_totp(secret, otp, interval, valid_window=1))

    def test_expired_onetime_password(self):
        secret = 'the elapsed secret'
        interval = 1
        otp = generate_totp(secret, interval).now()

        time.sleep(2)
        self.assertFalse(verify_totp(secret, otp, interval, valid_window=1))
