#!/usr/bin/python3

import io
import re

from os.path import dirname
from os.path import join

from setuptools import setup, find_packages


def get_version():
    with open('aspen_crypto/__init__.py', 'r') as f:
        line = f.readline()
        match = re.match(r'__version__ = \'([\d\.]+)\'', line)

        if not match:
            raise ImportError("Can't read the version of aspen_crypto")

        version = match.group(1)
        return version


def read(*names, **kwargs):
    return io.open(
        join(dirname(__file__), *names),
        encoding=kwargs.get('encoding', 'utf8'),
    ).read()


setup(
    name='aspen_crypto',
    version=get_version(),
    description='Aspen Cryptography Classes',
    long_description='%s\n%s'
    % (
        re.compile('^.. start-badges.*^.. end-badges', re.M | re.S).sub('', read('README.md')),
        re.sub(':[a-z]+:`~?(.*?)`', r'``\1``', read('CHANGELOG.md')),
    ),
    long_description_content_type='text/markdown',
    author='Dave Burkholder',
    author_email='dave@compassfoundation.io',
    url='https://code.compassfoundation.io/aspen/aspen_crypto',
    packages=find_packages(exclude=["tests"]),
    include_package_data=True,
    zip_safe=False,
    classifiers=[
        'Intended Audience :: Developers',
        'License :: SAP',
        'Operating System :: Unix',
        'Operating System :: POSIX',
        'Programming Language :: Python :: 3.11',
        'Programming Language :: Python :: Implementation :: CPython',
        'Topic :: Utilities',
    ],
    install_requires=[
        'cryptography',
        'lclazy',
        'pyseto',
    ],
)
