import binascii
import codecs

try:
    from pybase64 import b64decode, urlsafe_b64encode
except (ImportError, ModuleNotFoundError):
    from base64 import b64decode, urlsafe_b64encode


def mask(string: str) -> str:
    """
    Mask / encode a string so that it's actual, useful form
    is not ever presented directly to human eyes.
    """
    value = codecs.encode(string[::-1], 'rot13').swapcase().encode()
    return urlsafe_b64encode(value).decode()


def unmask(string: str) -> str:
    """
    Reverse the process of masking a string.
    """
    try:
        value = b64decode(string).decode()[::-1]
    except binascii.Error:
        print('Value was not masked')
        return string
    return codecs.encode(value, 'rot13').swapcase()


__all__ = (
    'mask',
    'unmask',
)
